
#include "TrigTables.h"

const signed short SineTable[1024] __attribute__((space(prog))) = {
0, 201, 402, 603, 804, 1005, 1206, 1406,
1607, 1808, 2009, 2209, 2410, 2610, 2811, 3011,
3211, 3411, 3611, 3811, 4011, 4210, 4409, 4608,
4807, 5006, 5205, 5403, 5601, 5799, 5997, 6195,
6392, 6589, 6786, 6982, 7179, 7375, 7571, 7766,
7961, 8156, 8351, 8545, 8739, 8932, 9126, 9319,
9511, 9703, 9895, 10087, 10278, 10469, 10659, 10849,
11038, 11227, 11416, 11604, 11792, 11980, 12166, 12353,
12539, 12724, 12909, 13094, 13278, 13462, 13645, 13827,
14009, 14191, 14372, 14552, 14732, 14911, 15090, 15268,
15446, 15623, 15799, 15975, 16150, 16325, 16499, 16672,
16845, 17017, 17189, 17360, 17530, 17699, 17868, 18036,
18204, 18371, 18537, 18702, 18867, 19031, 19194, 19357,
19519, 19680, 19840, 20000, 20159, 20317, 20474, 20631,
20787, 20942, 21096, 21249, 21402, 21554, 21705, 21855,
22004, 22153, 22301, 22448, 22594, 22739, 22883, 23027,
23169, 23311, 23452, 23592, 23731, 23869, 24006, 24143,
24278, 24413, 24546, 24679, 24811, 24942, 25072, 25201,
25329, 25456, 25582, 25707, 25831, 25954, 26077, 26198,
26318, 26437, 26556, 26673, 26789, 26905, 27019, 27132,
27244, 27355, 27466, 27575, 27683, 27790, 27896, 28001,
28105, 28208, 28309, 28410, 28510, 28608, 28706, 28802,
28897, 28992, 29085, 29177, 29268, 29358, 29446, 29534,
29621, 29706, 29790, 29873, 29955, 30036, 30116, 30195,
30272, 30349, 30424, 30498, 30571, 30643, 30713, 30783,
30851, 30918, 30984, 31049, 31113, 31175, 31236, 31297,
31356, 31413, 31470, 31525, 31580, 31633, 31684, 31735,
31785, 31833, 31880, 31926, 31970, 32014, 32056, 32097,
32137, 32176, 32213, 32249, 32284, 32318, 32350, 32382,
32412, 32441, 32468, 32495, 32520, 32544, 32567, 32588,
32609, 32628, 32646, 32662, 32678, 32692, 32705, 32717,
32727, 32736, 32744, 32751, 32757, 32761, 32764, 32766,
32767, 32766, 32764, 32761, 32757, 32751, 32744, 32736,
32727, 32717, 32705, 32692, 32678, 32662, 32646, 32628,
32609, 32588, 32567, 32544, 32520, 32495, 32468, 32441,
32412, 32382, 32350, 32318, 32284, 32249, 32213, 32176,
32137, 32097, 32056, 32014, 31970, 31926, 31880, 31833,
31785, 31735, 31684, 31633, 31580, 31525, 31470, 31413,
31356, 31297, 31236, 31175, 31113, 31049, 30984, 30918,
30851, 30783, 30713, 30643, 30571, 30498, 30424, 30349,
30272, 30195, 30116, 30036, 29955, 29873, 29790, 29706,
29621, 29534, 29446, 29358, 29268, 29177, 29085, 28992,
28897, 28802, 28706, 28608, 28510, 28410, 28309, 28208,
28105, 28001, 27896, 27790, 27683, 27575, 27466, 27355,
27244, 27132, 27019, 26905, 26789, 26673, 26556, 26437,
26318, 26198, 26077, 25954, 25831, 25707, 25582, 25456,
25329, 25201, 25072, 24942, 24811, 24679, 24546, 24413,
24278, 24143, 24006, 23869, 23731, 23592, 23452, 23311,
23169, 23027, 22883, 22739, 22594, 22448, 22301, 22153,
22004, 21855, 21705, 21554, 21402, 21249, 21096, 20942,
20787, 20631, 20474, 20317, 20159, 20000, 19840, 19680,
19519, 19357, 19194, 19031, 18867, 18702, 18537, 18371,
18204, 18036, 17868, 17699, 17530, 17360, 17189, 17017,
16845, 16672, 16499, 16325, 16150, 15975, 15799, 15623,
15446, 15268, 15090, 14911, 14732, 14552, 14372, 14191,
14009, 13827, 13645, 13462, 13278, 13094, 12909, 12724,
12539, 12353, 12166, 11980, 11792, 11604, 11416, 11227,
11038, 10849, 10659, 10469, 10278, 10087, 9895, 9703,
9511, 9319, 9126, 8932, 8739, 8545, 8351, 8156,
7961, 7766, 7571, 7375, 7179, 6982, 6786, 6589,
6392, 6195, 5997, 5799, 5601, 5403, 5205, 5006,
4807, 4608, 4409, 4210, 4011, 3811, 3611, 3411,
3211, 3011, 2811, 2610, 2410, 2209, 2009, 1808,
1607, 1406, 1206, 1005, 804, 603, 402, 201,
0-201, -402, -603, -804, -1005, -1206, -1406,
-1607, -1808, -2009, -2209, -2410, -2610, -2811, -3011,
-3211, -3411, -3611, -3811, -4011, -4210, -4409, -4608,
-4807, -5006, -5205, -5403, -5601, -5799, -5997, -6195,
-6392, -6589, -6786, -6982, -7179, -7375, -7571, -7766,
-7961, -8156, -8351, -8545, -8739, -8932, -9126, -9319,
-9511, -9703, -9895, -10087, -10278, -10469, -10659, -10849,
-11038, -11227, -11416, -11604, -11792, -11980, -12166, -12353,
-12539, -12724, -12909, -13094, -13278, -13462, -13645, -13827,
-14009, -14191, -14372, -14552, -14732, -14911, -15090, -15268,
-15446, -15623, -15799, -15975, -16150, -16325, -16499, -16672,
-16845, -17017, -17189, -17360, -17530, -17699, -17868, -18036,
-18204, -18371, -18537, -18702, -18867, -19031, -19194, -19357,
-19519, -19680, -19840, -20000, -20159, -20317, -20474, -20631,
-20787, -20942, -21096, -21249, -21402, -21554, -21705, -21855,
-22004, -22153, -22301, -22448, -22594, -22739, -22883, -23027,
-23169, -23311, -23452, -23592, -23731, -23869, -24006, -24143,
-24278, -24413, -24546, -24679, -24811, -24942, -25072, -25201,
-25329, -25456, -25582, -25707, -25831, -25954, -26077, -26198,
-26318, -26437, -26556, -26673, -26789, -26905, -27019, -27132,
-27244, -27355, -27466, -27575, -27683, -27790, -27896, -28001,
-28105, -28208, -28309, -28410, -28510, -28608, -28706, -28802,
-28897, -28992, -29085, -29177, -29268, -29358, -29446, -29534,
-29621, -29706, -29790, -29873, -29955, -30036, -30116, -30195,
-30272, -30349, -30424, -30498, -30571, -30643, -30713, -30783,
-30851, -30918, -30984, -31049, -31113, -31175, -31236, -31297,
-31356, -31413, -31470, -31525, -31580, -31633, -31684, -31735,
-31785, -31833, -31880, -31926, -31970, -32014, -32056, -32097,
-32137, -32176, -32213, -32249, -32284, -32318, -32350, -32382,
-32412, -32441, -32468, -32495, -32520, -32544, -32567, -32588,
-32609, -32628, -32646, -32662, -32678, -32692, -32705, -32717,
-32727, -32736, -32744, -32751, -32757, -32761, -32764, -32766,
-32767, -32766, -32764, -32761, -32757, -32751, -32744, -32736,
-32727, -32717, -32705, -32692, -32678, -32662, -32646, -32628,
-32609, -32588, -32567, -32544, -32520, -32495, -32468, -32441,
-32412, -32382, -32350, -32318, -32284, -32249, -32213, -32176,
-32137, -32097, -32056, -32014, -31970, -31926, -31880, -31833,
-31785, -31735, -31684, -31633, -31580, -31525, -31470, -31413,
-31356, -31297, -31236, -31175, -31113, -31049, -30984, -30918,
-30851, -30783, -30713, -30643, -30571, -30498, -30424, -30349,
-30272, -30195, -30116, -30036, -29955, -29873, -29790, -29706,
-29621, -29534, -29446, -29358, -29268, -29177, -29085, -28992,
-28897, -28802, -28706, -28608, -28510, -28410, -28309, -28208,
-28105, -28001, -27896, -27790, -27683, -27575, -27466, -27355,
-27244, -27132, -27019, -26905, -26789, -26673, -26556, -26437,
-26318, -26198, -26077, -25954, -25831, -25707, -25582, -25456,
-25329, -25201, -25072, -24942, -24811, -24679, -24546, -24413,
-24278, -24143, -24006, -23869, -23731, -23592, -23452, -23311,
-23169, -23027, -22883, -22739, -22594, -22448, -22301, -22153,
-22004, -21855, -21705, -21554, -21402, -21249, -21096, -20942,
-20787, -20631, -20474, -20317, -20159, -20000, -19840, -19680,
-19519, -19357, -19194, -19031, -18867, -18702, -18537, -18371,
-18204, -18036, -17868, -17699, -17530, -17360, -17189, -17017,
-16845, -16672, -16499, -16325, -16150, -15975, -15799, -15623,
-15446, -15268, -15090, -14911, -14732, -14552, -14372, -14191,
-14009, -13827, -13645, -13462, -13278, -13094, -12909, -12724,
-12539, -12353, -12166, -11980, -11792, -11604, -11416, -11227,
-11038, -10849, -10659, -10469, -10278, -10087, -9895, -9703,
-9511, -9319, -9126, -8932, -8739, -8545, -8351, -8156,
-7961, -7766, -7571, -7375, -7179, -6982, -6786, -6589,
-6392, -6195, -5997, -5799, -5601, -5403, -5205, -5006,
-4807, -4608, -4409, -4210, -4011, -3811, -3611, -3411,
-3211, -3011, -2811, -2610, -2410, -2209, -2009, -1808,
-1607, -1406, -1206, -1005, -804, -603, -402, -201 };

const int TanTable[512] __attribute__((space(prog))) = {
0, 100, 201, 301, 402, 502, 603, 703,
804, 904, 1005, 1106, 1206, 1307, 1408, 1508,
1609, 1710, 1811, 1912, 2013, 2114, 2214, 2315,
2417, 2518, 2619, 2720, 2821, 2923, 3024, 3125,
3227, 3328, 3430, 3532, 3633, 3735, 3837, 3939,
4041, 4143, 4245, 4347, 4450, 4552, 4655, 4757,
4860, 4963, 5066, 5169, 5272, 5375, 5478, 5582,
5685, 5789, 5892, 5996, 6100, 6204, 6309, 6413,
6517, 6622, 6727, 6831, 6936, 7041, 7147, 7252,
7358, 7463, 7569, 7675, 7781, 7887, 7994, 8100,
8207, 8314, 8421, 8528, 8636, 8743, 8851, 8959,
9067, 9176, 9284, 9393, 9502, 9611, 9720, 9830,
9939, 10049, 10159, 10270, 10380, 10491, 10602, 10713,
10824, 10936, 11048, 11160, 11272, 11385, 11497, 11610,
11724, 11837, 11951, 12065, 12179, 12294, 12409, 12524,
12639, 12755, 12871, 12987, 13103, 13220, 13337, 13454,
13572, 13690, 13808, 13927, 14046, 14165, 14284, 14404,
14524, 14645, 14765, 14886, 15008, 15130, 15252, 15374,
15497, 15620, 15744, 15868, 15992, 16117, 16242, 16367,
16493, 16619, 16746, 16873, 17000, 17128, 17256, 17385,
17514, 17643, 17773, 17904, 18034, 18165, 18297, 18429,
18562, 18695, 18828, 18962, 19097, 19232, 19367, 19503,
19639, 19776, 19914, 20051, 20190, 20329, 20468, 20608,
20749, 20890, 21032, 21174, 21317, 21460, 21604, 21749,
21894, 22039, 22186, 22333, 22480, 22628, 22777, 22927,
23077, 23227, 23379, 23531, 23683, 23837, 23991, 24146,
24301, 24457, 24614, 24772, 24930, 25089, 25249, 25410,
25571, 25733, 25896, 26060, 26224, 26390, 26556, 26723,
26891, 27059, 27229, 27399, 27571, 27743, 27916, 28090,
28265, 28440, 28617, 28795, 28973, 29153, 29334, 29515,
29698, 29881, 30066, 30252, 30438, 30626, 30815, 31005,
31196, 31388, 31582, 31776, 31972, 32169, 32367, 32566,
32766, 32968, 33171, 33375, 33581, 33788, 33996, 34205,
34416, 34628, 34841, 35056, 35273, 35490, 35709, 35930,
36152, 36376, 36601, 36828, 37056, 37286, 37518, 37751,
37986, 38222, 38460, 38700, 38942, 39185, 39430, 39677,
39926, 40177, 40430, 40684, 40941, 41199, 41459, 41722,
41987, 42253, 42522, 42793, 43066, 43341, 43619, 43899,
44181, 44465, 44752, 45041, 45333, 45627, 45924, 46223,
46525, 46830, 47137, 47447, 47759, 48075, 48393, 48715,
49039, 49366, 49696, 50030, 50366, 50706, 51049, 51395,
51744, 52097, 52454, 52813, 53177, 53544, 53915, 54290,
54668, 55050, 55437, 55827, 56221, 56620, 57023, 57430,
57841, 58257, 58678, 59103, 59533, 59968, 60408, 60852,
61302, 61757, 62218, 62683, 63154, 63631, 64114, 64602,
65096, 65597, 66103, 66616, 67135, 67661, 68194, 68733,
69280, 69833, 70394, 70962, 71538, 72122, 72713, 73313,
73921, 74537, 75162, 75796, 76439, 77091, 77753, 78425,
79106, 79798, 80500, 81212, 81936, 82671, 83417, 84175,
84945, 85727, 86522, 87330, 88151, 88986, 89835, 90699,
91577, 92471, 93380, 94305, 95246, 96205, 97181, 98174,
99187, 100218, 101269, 102340, 103431, 104544, 105679, 106837,
108018, 109223, 110453, 111709, 112991, 114301, 115639, 117007,
118404, 119833, 121295, 122790, 124320, 125885, 127489, 129131,
130813, 132537, 134304, 136116, 137975, 139882, 141841, 143852,
145918, 148041, 150223, 152469, 154779, 157157, 159606, 162129,
164730, 167413, 170181, 173039, 175991, 179042, 182196, 185461,
188840, 192342, 195972, 199737, 203646, 207707, 211929, 216322,
220897, 225665, 230638, 235831, 241259, 246938, 252885, 259121,
265667, 272547, 279788, 287418, 295469, 303980, 312988, 322541,
332688, 343489, 355006, 367316, 380503, 394664, 409912, 426377,
444211, 463593, 484734, 507885, 533348, 561488, 592751, 627687,
666987, 711522, 762415, 821132, 889629, 970575, 1067703, 1186407,
1334779, 1525534, 1779862, 2135908, 2669961, 3560026, 5340123, 10680346 };

const unsigned short ExpTable[1024] __attribute__((space(prog))) =
{ 0, 16, 32, 49, 65, 82, 99, 115, 132, 149, 166, 182, 199, 216, 233, 250, 267, 284, 301, 318, 335, 352, 370, 387, 404, 422, 439, 456, 474, 491, 509, 527,
544, 562, 579, 597, 615, 633, 651, 669, 687, 705, 723, 741, 759, 777, 795, 813, 832, 850, 868, 887, 905, 923, 942, 961, 979, 998, 1016, 1035, 1054, 1073, 1092, 1110,
1129, 1148, 1167, 1186, 1206, 1225, 1244, 1263, 1282, 1302, 1321, 1341, 1360, 1379, 1399, 1419, 1438, 1458, 1478, 1497, 1517, 1537, 1557, 1577, 1597, 1617, 1637, 1657, 1677, 1697, 1718, 1738,
1758, 1779, 1799, 1820, 1840, 1861, 1881, 1902, 1923, 1944, 1964, 1985, 2006, 2027, 2048, 2069, 2090, 2111, 2133, 2154, 2175, 2196, 2218, 2239, 2261, 2282, 2304, 2325, 2347, 2369, 2391, 2412,
2434, 2456, 2478, 2500, 2522, 2544, 2566, 2589, 2611, 2633, 2656, 2678, 2700, 2723, 2746, 2768, 2791, 2814, 2836, 2859, 2882, 2905, 2928, 2951, 2974, 2997, 3020, 3044, 3067, 3090, 3114, 3137,
3160, 3184, 3208, 3231, 3255, 3279, 3303, 3326, 3350, 3374, 3398, 3422, 3447, 3471, 3495, 3519, 3544, 3568, 3593, 3617, 3642, 3666, 3691, 3716, 3741, 3765, 3790, 3815, 3840, 3865, 3891, 3916,
3941, 3966, 3992, 4017, 4043, 4068, 4094, 4119, 4145, 4171, 4197, 4222, 4248, 4274, 4300, 4327, 4353, 4379, 4405, 4432, 4458, 4485, 4511, 4538, 4564, 4591, 4618, 4645, 4671, 4698, 4725, 4753,
4780, 4807, 4834, 4861, 4889, 4916, 4944, 4971, 4999, 5027, 5054, 5082, 5110, 5138, 5166, 5194, 5222, 5250, 5279, 5307, 5335, 5364, 5392, 5421, 5450, 5478, 5507, 5536, 5565, 5594, 5623, 5652,
5681, 5710, 5739, 5769, 5798, 5828, 5857, 5887, 5917, 5946, 5976, 6006, 6036, 6066, 6096, 6126, 6156, 6187, 6217, 6248, 6278, 6309, 6339, 6370, 6401, 6432, 6463, 6493, 6525, 6556, 6587, 6618,
6649, 6681, 6712, 6744, 6775, 6807, 6839, 6871, 6903, 6935, 6967, 6999, 7031, 7063, 7096, 7128, 7160, 7193, 7226, 7258, 7291, 7324, 7357, 7390, 7423, 7456, 7489, 7523, 7556, 7589, 7623, 7657,
7690, 7724, 7758, 7792, 7826, 7860, 7894, 7928, 7962, 7997, 8031, 8066, 8100, 8135, 8170, 8204, 8239, 8274, 8309, 8345, 8380, 8415, 8450, 8486, 8521, 8557, 8593, 8629, 8664, 8700, 8736, 8772,
8809, 8845, 8881, 8918, 8954, 8991, 9027, 9064, 9101, 9138, 9175, 9212, 9249, 9287, 9324, 9361, 9399, 9436, 9474, 9512, 9550, 9588, 9626, 9664, 9702, 9740, 9779, 9817, 9856, 9894, 9933, 9972,
10011, 10049, 10089, 10128, 10167, 10206, 10246, 10285, 10325, 10364, 10404, 10444, 10484, 10524, 10564, 10604, 10645, 10685, 10726, 10766, 10807, 10848, 10888, 10929, 10970, 11012, 11053, 11094, 11135, 11177, 11219, 11260,
11302, 11344, 11386, 11428, 11470, 11512, 11555, 11597, 11640, 11682, 11725, 11768, 11811, 11854, 11897, 11940, 11984, 12027, 12070, 12114, 12158, 12202, 12245, 12289, 12334, 12378, 12422, 12466, 12511, 12556, 12600, 12645,
12690, 12735, 12780, 12825, 12871, 12916, 12961, 13007, 13053, 13099, 13145, 13191, 13237, 13283, 13329, 13376, 13422, 13469, 13516, 13563, 13609, 13657, 13704, 13751, 13798, 13846, 13894, 13941, 13989, 14037, 14085, 14133,
14181, 14230, 14278, 14327, 14375, 14424, 14473, 14522, 14571, 14621, 14670, 14719, 14769, 14819, 14868, 14918, 14968, 15018, 15069, 15119, 15170, 15220, 15271, 15322, 15373, 15424, 15475, 15526, 15577, 15629, 15681, 15732,
15784, 15836, 15888, 15940, 15993, 16045, 16098, 16150, 16203, 16256, 16309, 16362, 16416, 16469, 16522, 16576, 16630, 16684, 16738, 16792, 16846, 16900, 16955, 17009, 17064, 17119, 17174, 17229, 17284, 17340, 17395, 17451,
17506, 17562, 17618, 17674, 17731, 17787, 17843, 17900, 17957, 18014, 18071, 18128, 18185, 18242, 18300, 18357, 18415, 18473, 18531, 18589, 18648, 18706, 18764, 18823, 18882, 18941, 19000, 19059, 19119, 19178, 19238, 19297,
19357, 19417, 19477, 19538, 19598, 19659, 19719, 19780, 19841, 19902, 19963, 20025, 20086, 20148, 20210, 20272, 20334, 20396, 20458, 20521, 20583, 20646, 20709, 20772, 20835, 20899, 20962, 21026, 21090, 21153, 21218, 21282,
21346, 21411, 21475, 21540, 21605, 21670, 21735, 21801, 21866, 21932, 21998, 22063, 22130, 22196, 22262, 22329, 22395, 22462, 22529, 22596, 22664, 22731, 22799, 22867, 22935, 23003, 23071, 23139, 23208, 23276, 23345, 23414,
23483, 23553, 23622, 23692, 23761, 23831, 23901, 23972, 24042, 24113, 24183, 24254, 24325, 24396, 24468, 24539, 24611, 24683, 24755, 24827, 24899, 24972, 25044, 25117, 25190, 25263, 25337, 25410, 25484, 25558, 25632, 25706,
25780, 25855, 25929, 26004, 26079, 26154, 26229, 26305, 26381, 26456, 26532, 26608, 26685, 26761, 26838, 26915, 26992, 27069, 27146, 27224, 27302, 27380, 27458, 27536, 27614, 27693, 27772, 27851, 27930, 28009, 28089, 28168,
28248, 28328, 28408, 28489, 28569, 28650, 28731, 28812, 28893, 28975, 29057, 29138, 29220, 29303, 29385, 29468, 29550, 29633, 29716, 29800, 29883, 29967, 30051, 30135, 30219, 30304, 30388, 30473, 30558, 30643, 30729, 30815,
30900, 30986, 31073, 31159, 31245, 31332, 31419, 31506, 31594, 31681, 31769, 31857, 31945, 32033, 32122, 32211, 32300, 32389, 32478, 32568, 32658, 32747, 32838, 32928, 33019, 33109, 33200, 33291, 33383, 33474, 33566, 33658,
33750, 33843, 33935, 34028, 34121, 34215, 34308, 34402, 34496, 34590, 34684, 34778, 34873, 34968, 35063, 35159, 35254, 35350, 35446, 35542, 35639, 35735, 35832, 35929, 36027, 36124, 36222, 36320, 36418, 36517, 36615, 36714,
36813, 36912, 37012, 37112, 37212, 37312, 37412, 37513, 37614, 37715, 37816, 37918, 38020, 38122, 38224, 38326, 38429, 38532, 38635, 38739, 38842, 38946, 39050, 39155, 39259, 39364, 39469, 39574, 39680, 39786, 39892, 39998,
40104, 40211, 40318, 40425, 40533, 40640, 40748, 40856, 40965, 41073, 41182, 41292, 41401, 41511, 41620, 41731, 41841, 41952, 42062, 42174, 42285, 42397, 42508, 42621, 42733, 42846, 42958, 43072, 43185, 43299, 43413, 43527,
43641, 43756, 43871, 43986, 44101, 44217, 44333, 44449, 44566, 44683, 44800, 44917, 45034, 45152, 45270, 45389, 45507, 45626, 45745, 45865, 45984, 46104, 46225, 46345, 46466, 46587, 46708, 46830, 46952, 47074, 47196, 47319,
47442, 47565, 47689, 47812, 47936, 48061, 48185, 48310, 48435, 48561, 48687, 48813, 48939, 49066, 49192, 49320, 49447, 49575, 49703, 49831, 49960, 50089, 50218, 50347, 50477, 50607, 50738, 50868, 50999, 51130, 51262, 51394,
51526, 51658, 51791, 51924, 52057, 52191, 52325, 52459, 52594, 52729, 52864, 52999, 53135, 53271, 53407, 53544, 53681, 53818, 53956, 54094, 54232, 54370, 54509, 54648, 54788, 54928, 55068, 55208, 55349, 55490, 55631, 55773,
55915, 56057, 56200, 56343, 56486, 56630, 56774, 56918, 57062, 57207, 57352, 57498, 57644, 57790, 57937, 58083, 58231, 58378, 58526, 58674, 58823, 58972, 59121, 59270, 59420, 59570, 59721, 59872, 60023, 60175, 60326, 60479,
60631, 60784, 60937, 61091, 61245, 61399, 61554, 61709, 61864, 62020, 62176, 62332, 62489, 62646, 62804, 62962, 63120, 63278, 63437, 63596, 63756, 63916, 64076, 64237, 64398, 64559, 64721, 64883, 65046, 65209, 65372 };

const signed short LogAdjSineTable[1024] __attribute__((space(prog))) =
{ -8653, -8504, -8355, -8205, -8054, -7902, -7749, -7596,
-7441, -7285, -7129, -6972, -6813, -6654, -6494, -6333,
-6171, -6009, -5845, -5681, -5515, -5349, -5182, -5014,
-4845, -4675, -4504, -4333, -4160, -3987, -3813, -3638,
-3462, -3286, -3108, -2930, -2751, -2571, -2390, -2208,
-2026, -1843, -1658, -1474, -1288, -1102, -914, -726,
-538, -348, -158, 32, 224, 416, 610, 803,
998, 1193, 1389, 1586, 1783, 1981, 2180, 2379,
2579, 2780, 2981, 3183, 3385, 3588, 3792, 3996,
4201, 4406, 4612, 4818, 5025, 5232, 5440, 5648,
5857, 6066, 6275, 6485, 6696, 6906, 7117, 7329,
7541, 7753, 7966, 8178, 8392, 8605, 8819, 9033,
9247, 9461, 9676, 9890, 10105, 10320, 10535, 10751,
10966, 11182, 11397, 11613, 11828, 12044, 12260, 12475,
12691, 12906, 13122, 13337, 13552, 13767, 13982, 14197,
14411, 14626, 14840, 15053, 15267, 15480, 15693, 15906,
16118, 16330, 16541, 16752, 16963, 17173, 17382, 17591,
17800, 18008, 18215, 18422, 18628, 18834, 19039, 19243,
19447, 19650, 19852, 20053, 20253, 20453, 20652, 20850,
21047, 21243, 21438, 21633, 21826, 22018, 22210, 22400,
22589, 22777, 22964, 23150, 23335, 23518, 23700, 23881,
24061, 24240, 24417, 24593, 24768, 24941, 25113, 25283,
25452, 25620, 25786, 25951, 26114, 26276, 26436, 26594,
26751, 26906, 27060, 27212, 27362, 27511, 27658, 27803,
27946, 28088, 28228, 28366, 28502, 28636, 28769, 28899,
29028, 29155, 29280, 29402, 29523, 29642, 29759, 29874,
29986, 30097, 30206, 30312, 30417, 30519, 30619, 30717,
30813, 30907, 30998, 31088, 31175, 31259, 31342, 31422,
31500, 31576, 31650, 31721, 31790, 31856, 31920, 31982,
32042, 32099, 32154, 32206, 32256, 32304, 32349, 32392,
32432, 32470, 32506, 32539, 32570, 32598, 32624, 32647,
32668, 32686, 32702, 32716, 32727, 32736, 32742, 32746,
32747, 32746, 32742, 32736, 32727, 32716, 32702, 32686,
32668, 32647, 32624, 32598, 32570, 32539, 32506, 32470,
32432, 32392, 32349, 32304, 32256, 32206, 32154, 32099,
32042, 31982, 31920, 31856, 31790, 31721, 31650, 31576,
31500, 31422, 31342, 31259, 31175, 31088, 30998, 30907,
30813, 30717, 30619, 30519, 30417, 30312, 30206, 30097,
29986, 29874, 29759, 29642, 29523, 29402, 29280, 29155,
29028, 28899, 28769, 28636, 28502, 28366, 28228, 28088,
27946, 27803, 27658, 27511, 27362, 27212, 27060, 26906,
26751, 26594, 26436, 26276, 26114, 25951, 25786, 25620,
25452, 25283, 25113, 24941, 24768, 24593, 24417, 24240,
24061, 23881, 23700, 23518, 23335, 23150, 22964, 22777,
22589, 22400, 22210, 22018, 21826, 21633, 21438, 21243,
21047, 20850, 20652, 20453, 20253, 20053, 19852, 19650,
19447, 19243, 19039, 18834, 18628, 18422, 18215, 18008,
17800, 17591, 17382, 17173, 16963, 16752, 16541, 16330,
16118, 15906, 15693, 15480, 15267, 15053, 14840, 14626,
14411, 14197, 13982, 13767, 13552, 13337, 13122, 12906,
12691, 12475, 12260, 12044, 11828, 11613, 11397, 11182,
10966, 10751, 10535, 10320, 10105, 9890, 9676, 9461,
9247, 9033, 8819, 8605, 8392, 8178, 7966, 7753,
7541, 7329, 7117, 6906, 6696, 6485, 6275, 6066,
5857, 5648, 5440, 5232, 5025, 4818, 4612, 4406,
4201, 3996, 3792, 3588, 3385, 3183, 2981, 2780,
2579, 2379, 2180, 1981, 1783, 1586, 1389, 1193,
998, 803, 610, 416, 224, 32, -158, -348,
-538, -726, -914, -1102, -1288, -1474, -1658, -1843,
-2026, -2208, -2390, -2571, -2751, -2930, -3108, -3286,
-3462, -3638, -3813, -3987, -4160, -4333, -4504, -4675,
-4845, -5014, -5182, -5349, -5515, -5681, -5845, -6009,
-6171, -6333, -6494, -6654, -6813, -6972, -7129, -7285,
-7441, -7596, -7749, -7902, -8054, -8205, -8355, -8504,
-8653, -8800, -8947, -9092, -9237, -9381, -9523, -9665,
-9806, -9947, -10086, -10224, -10362, -10498, -10634, -10768,
-10902, -11035, -11167, -11298, -11429, -11558, -11687, -11814,
-11941, -12067, -12192, -12316, -12439, -12561, -12683, -12803,
-12923, -13042, -13160, -13277, -13393, -13509, -13623, -13737,
-13850, -13962, -14073, -14184, -14293, -14402, -14510, -14617,
-14723, -14829, -14933, -15037, -15140, -15242, -15344, -15444,
-15544, -15643, -15741, -15839, -15935, -16031, -16126, -16220,
-16314, -16407, -16499, -16590, -16680, -16770, -16859, -16947,
-17035, -17122, -17208, -17293, -17378, -17462, -17545, -17627,
-17709, -17790, -17870, -17950, -18029, -18107, -18185, -18261,
-18338, -18413, -18488, -18562, -18636, -18708, -18781, -18852,
-18923, -18993, -19063, -19132, -19200, -19268, -19335, -19401,
-19467, -19532, -19596, -19660, -19724, -19786, -19848, -19910,
-19971, -20031, -20091, -20150, -20208, -20266, -20324, -20381,
-20437, -20493, -20548, -20602, -20656, -20710, -20763, -20815,
-20867, -20918, -20969, -21019, -21069, -21118, -21166, -21215,
-21262, -21309, -21356, -21402, -21447, -21492, -21537, -21581,
-21624, -21667, -21710, -21752, -21794, -21835, -21875, -21916,
-21955, -21994, -22033, -22072, -22109, -22147, -22184, -22220,
-22256, -22292, -22327, -22361, -22395, -22429, -22463, -22495,
-22528, -22560, -22592, -22623, -22653, -22684, -22714, -22743,
-22772, -22801, -22829, -22857, -22884, -22911, -22938, -22964,
-22990, -23015, -23040, -23065, -23089, -23113, -23136, -23159,
-23182, -23204, -23226, -23248, -23269, -23290, -23310, -23330,
-23349, -23369, -23388, -23406, -23424, -23442, -23459, -23476,
-23493, -23509, -23525, -23541, -23556, -23571, -23585, -23600,
-23613, -23627, -23640, -23653, -23665, -23677, -23689, -23700,
-23711, -23722, -23732, -23742, -23752, -23761, -23770, -23778,
-23787, -23795, -23802, -23809, -23816, -23823, -23829, -23835,
-23840, -23845, -23850, -23855, -23859, -23863, -23866, -23870,
-23872, -23875, -23877, -23879, -23880, -23882, -23882, -23883,
-23883, -23883, -23882, -23882, -23880, -23879, -23877, -23875,
-23872, -23870, -23866, -23863, -23859, -23855, -23850, -23845,
-23840, -23835, -23829, -23823, -23816, -23809, -23802, -23795,
-23787, -23778, -23770, -23761, -23752, -23742, -23732, -23722,
-23711, -23700, -23689, -23677, -23665, -23653, -23640, -23627,
-23613, -23600, -23585, -23571, -23556, -23541, -23525, -23509,
-23493, -23476, -23459, -23442, -23424, -23406, -23388, -23369,
-23349, -23330, -23310, -23290, -23269, -23248, -23226, -23204,
-23182, -23159, -23136, -23113, -23089, -23065, -23040, -23015,
-22990, -22964, -22938, -22911, -22884, -22857, -22829, -22801,
-22772, -22743, -22714, -22684, -22653, -22623, -22592, -22560,
-22528, -22495, -22463, -22429, -22395, -22361, -22327, -22292,
-22256, -22220, -22184, -22147, -22109, -22072, -22033, -21994,
-21955, -21916, -21875, -21835, -21794, -21752, -21710, -21667,
-21624, -21581, -21537, -21492, -21447, -21402, -21356, -21309,
-21262, -21215, -21166, -21118, -21069, -21019, -20969, -20918,
-20867, -20815, -20763, -20710, -20656, -20602, -20548, -20493,
-20437, -20381, -20324, -20266, -20208, -20150, -20091, -20031,
-19971, -19910, -19848, -19786, -19724, -19660, -19596, -19532,
-19467, -19401, -19335, -19268, -19200, -19132, -19063, -18993,
-18923, -18852, -18781, -18708, -18636, -18562, -18488, -18413,
-18338, -18261, -18185, -18107, -18029, -17950, -17870, -17790,
-17709, -17627, -17545, -17462, -17378, -17293, -17208, -17122,
-17035, -16947, -16859, -16770, -16680, -16590, -16499, -16407,
-16314, -16220, -16126, -16031, -15935, -15839, -15741, -15643,
-15544, -15444, -15344, -15242, -15140, -15037, -14933, -14829,
-14723, -14617, -14510, -14402, -14293, -14184, -14073, -13962,
-13850, -13737, -13623, -13509, -13393, -13277, -13160, -13042,
-12923, -12803, -12683, -12561, -12439, -12316, -12192, -12067,
-11941, -11814, -11687, -11558, -11429, -11298, -11167, -11035,
-10902, -10768, -10634, -10498, -10362, -10224, -10086, -9947,
-9806, -9665, -9523, -9381, -9237, -9092, -8947, -8800 };
